#ifndef __LIB_EMUC_H__
#define __LIB_EMUC_H__ 

/*------------------------------------------------------------------------------------------------------------*/
#define MAX_COM_PORT    256
#define MAX_BUF         512

#define ID_LEN          4
#define DATA_LEN        8   
#define VER_LEN         16

#define DIM(var, type)  (sizeof(var)) / sizeof(type)

/*------------------------------------------------------------------------------------------------------------*/
enum
{
    /* channel */
    EMUC_CH_1           = 1,
    EMUC_CH_2,
    EMUC_CH_BOTH,

    /* baudrate */
    EMUC_BAUDRATE_5K    = 0,
    EMUC_BAUDRATE_10K,
    EMUC_BAUDRATE_20K,
    EMUC_BAUDRATE_50K,
    EMUC_BAUDRATE_125K,
    EMUC_BAUDRATE_250K,
    EMUC_BAUDRATE_500K,
    EMUC_BAUDRATE_1M,
};

typedef struct
{
    int           com_port;

    int           channel;
    int           mod;
    int           rtr;
    int           dlc;

    unsigned char id[ID_LEN];
    unsigned char data[DATA_LEN];

} DATA_INFO;

typedef struct
{
    char fw[VER_LEN];
    char api[VER_LEN];
} VER_INFO;

/*------------------------------------------------------------------------------------------------------------*/
typedef int  (*EMUC_OPEN_DEVICE)  (int port);
typedef void (*EMUC_CLOSE_DEVICE) (int port);
typedef int  (*EMUC_SHOW_VER)     (int port, VER_INFO *ver);
typedef int  (*EMUC_SET_CAN)      (int port, int ch, int bdrate);
typedef int  (*EMUC_RESET)        (int port);
typedef int  (*EMUC_RECEIVE)      (DATA_INFO *info);
typedef int  (*EMUC_SEND)         (DATA_INFO *info);
typedef int  (*EMUC_RECV_NONBLOCK)(DATA_INFO *info, int cnt, unsigned int interval);

#endif

/* load library */
/*
static HMODULE 	         hDLL;
static EMUC_OPEN_DEVICE  EMUCOpenDevice;
static EMUC_CLOSE_DEVICE EMUCCloseDevice;
static EMUC_SHOW_VER     EMUCShowVer;
static EMUC_SET_CAN      EMUCSetCAN;
static EMUC_RESET        EMUCReset;
static EMUC_RECEIVE      EMUCReceive;
static EMUC_SEND         EMUCSend;
static EMUC_RECV_NONBLOCK EMUCReceiveNonblock;

static int load_dll(void)
{
   hDLL = LoadLibrary("lib_emuc.dll");

   if(!hDLL)
      return FALSE;

   EMUCOpenDevice  = (EMUC_OPEN_DEVICE)  GetProcAddress(hDLL, "EMUCOpenDevice"); 
   EMUCCloseDevice = (EMUC_CLOSE_DEVICE) GetProcAddress(hDLL, "EMUCCloseDevice"); 
   EMUCShowVer     = (EMUC_SHOW_VER)     GetProcAddress(hDLL, "EMUCShowVer"); 
   EMUCSetCAN      = (EMUC_SET_CAN)      GetProcAddress(hDLL, "EMUCSetCAN"); 
   EMUCReset       = (EMUC_RESET)        GetProcAddress(hDLL, "EMUCReset");  
   EMUCReceive     = (EMUC_RECEIVE)      GetProcAddress(hDLL, "EMUCReceive"); 
   EMUCSend        = (EMUC_SEND)         GetProcAddress(hDLL, "EMUCSend"); 
   EMUCReceiveNonblock     = (EMUC_RECEIVE)      GetProcAddress(hDLL, "EMUCReceiveNonblock"); 
   
   return TRUE;
}
*/