#!/bin/bash
# VERSION 	5.4
# DATE		2022/08/22
# functions for centos debug.

# How to Ignore Failures in a Shell Step? 
# https://support.cloudbees.com/hc/en-us/articles/218517228-How-to-Ignore-Failures-in-a-Shell-Step-
# # Enable exit on non 0
# set -e

# Disable exit on non 0
set +e

VERSION="R5.4 2022/08/22"

source "../bash_functions.sh"
source "jetson_variables.sh"

PATH_CURR=`pwd`
D_VER=`uname -r`
PATH_MODULE="/lib/modules/${D_VER}"
PATH_MODULE_MISC="/lib/modules/${D_VER}/misc"
FN="log_setup.txt"

apt_extra_repository()
{
	sudo add-apt-repository universe
	sudo add-apt-repository multiverse
	#sudo apt-add-repository ppa:/relan/exfat
	sudo apt-get update
}

#install package
PkgInstall()
{
 	if [ -z "$1" ]; then
		echo "package is empty"
		exit 1
    fi

	# check wget is exist
	QUERY_CMD="apt -qq list $1"
	#echo "command = " $QUERY_CMD

	QUERY_PKG=`$QUERY_CMD`
	echo $QUERY_PKG

	if [[ $QUERY_PKG != *"[installed]"* ]]; then
		#only do the update when the package is not installed.
		echo "sudo apt-get update"
		#sudo apt-get update

		echo "sudo apt-get install -y $1"
		sudo apt-get install -y $1

		#QUERY_PKG=`$QUERY_CMD`
		#if [[ $QUERY_PKG != *"[installed]"* ]]; then
		#	"Can't install the $1, please check your internet connection!"
		#	exit 1
		#fi
	fi
}


echo_title()
{
	echo "=====================================" >> ${FN}
	echo $@ >> ${FN} 
	echo "=====================================" >> ${FN}
}

run_cmd()
{
	echo_title $@
	$@ >> ${FN}
	
	#print to console
	$@
}

get_kconfig()
{
	echo_title "kconfig"
	cp /proc/config.gz .
	gunzip config.gz
	cat config >> ${FN}
	
	#print to console
	echo "Get kconfig"
	cat config
	
	rm config
}

get_kconfig_ubuntux86()
{
	echo_title "Get kconfig"
	cat /boot/config-${D_VER} >> ${FN}
}


install_pkgs()
{
	echo_title "install_pkgs"
	#apt_extra_repository;
	PkgInstall v4l-utils;
	PkgInstall libxvmc-dev;
	PkgInstall qv4l2;
	PkgInstall libx11-dev;
	#PkgInstall dmidecode
}

print_version()
{
	echo_title ${VERSION}
	run_cmd uname -a
}

get_video_info()
{
	#QVIDEO=`v4l2-ctl --list-devices | grep /dev/video`
    #echo ${QVIDEO}
    #for V in ${QVIDEO}
    for V in `v4l2-ctl --list-devices | grep /dev/video`
	do
	    #echo ${V}
		#C=$(echo ${V} | sed 's/video///g')
		C=${V/\/dev\/video/}
		run_cmd v4l2-ctl -d ${C} --all
		run_cmd v4l2-ctl -d ${C} --list-formats-ext
	done    
}

get_audio_info()
{
	echo_title "get_audio_info"
    run_cmd arecord --list-devices | grep car
}

checkout_branches()
{
	cd ${DIR_CURR}
	cd ${1}
    #QBRANCH=`git branch -a`
	#echo ${QBRANCH}
    #run_cmd git checkout master
}

get_pci_devices()
{
	run_cmd lspci
}

get_dmesg()
{
	run_cmd dmesg
	run_cmd dmesg -T
}

ls_dir()
{
	if [ -d ${1} ];then
		run_cmd ls -l ${1} 
	fi
}

get_modinfo()
{
	echo_title "get_modinfo - ${1}"
	#The ko version must same as kernel release
	#01.Get the ko file list
	
	if [ ! -d "${1}" ];then
		return 
	fi
	cd ${1}
	
	# ignore error : https://www.unix.com/shell-programming-and-scripting/241905-how-ignore-error-command-bash-script.html 
	#STR_RET=$(ls -l *.ko) || true
	
	STR_RET=$(ls -l *.ko)
	#echo "STR_RET=${STR_RET}"
	
	#02.Compare the version between ko file ane kernel release
	text=${STR_RET}
	readarray -t strarr <<< "$text"
	
	for (( i=0; i<=${#strarr[*]}; i++ ))
	do
		#echo "${i}=${strarr[${i}]}"
		FN_KO=$(echo ${strarr[${i}]} | cut -d ' ' -f 9) 
		if [ -n "${FN_KO}" ];then
			#echo "FN_KO=${FN_KO}"
			run_cmd modinfo ${1}/${FN_KO} 
		fi
		
	done
	cd ${PATH_CURR}
}

get_driver()
{
	ls_dir /lib/firmware/
	ls_dir ${PATH_MODULE}
	ls_dir ${PATH_MODULE_MISC} 
	get_modinfo ${PATH_MODULE_MISC}
	run_cmd lsmod
}

get_jetson_variables()
{
	echo_title "get_jetson_variables"
	L4T=$(get_l4t_version)
	RBOARD=$(get_borad_v2)
	RJETPACK=$(get_jetpack_version $RBOARD)
	RCUDA=$(get_cuda_version)
	ROPENCV=$(get_opencv_version2)
	
	run_cmd echo "L4T=${L4T}"
	run_cmd echo "Board=${RBOARD}"
	run_cmd echo "Jetpack=${RJETPACK}"
	run_cmd echo "CUDA=${RCUDA}"
	run_cmd echo "Opencv=${ROPENCV}"
}

get_cpu()
{
	echo_title "get_cpu_info"
	run_cmd lscpu
}

get_dmidecode_info()
{
	# cpu
	#dmidecode -t processor  

	# pci slot
	echo_title "get_pci_slot"
	run_cmd dmidecode -t slot   
	
	# mother board    
	echo_title "get_board"
	run_cmd dmidecode -t baseboard  

	# memory    
	#echo_title "get_memory"
	#run_cmd dmidecode -t memory  
}

get_memory()
{
	echo_title "get_memory"
	run_cmd cat /proc/meminfo
}

get_hwinfo()
{
	echo_title "get_hwinfo"
	get_cpu
	run_cmd cat /proc/cpuinfo 
	get_memory
	run_cmd lshw 
}

main()
{
	echo "" > ${FN}
	print_version;
	#install_pkgs;
	get_kconfig;
	#get_kconfig_ubuntux86
	get_pci_devices
	get_dmesg
	get_driver
	get_video_info
	get_audio_info
	get_jetson_variables
	get_cpu
	get_memory
	#get_dmidecode_info
}

main $@
