#ifndef __CAN_LIB_H_
#define __CAN_LIB_H_

#include <windows.h>
#include <winioctl.h>

#ifdef __cplusplus
extern "C"
{
#endif

//###########################################################################
//# CAN Windows API Defines                                                   #
//###########################################################################

#define TRUE 1
#define FALSE 0


#define MSG_ACTIVE	(0)		/**< Controller Error Active */
#define MSG_BASE	(0)		/**< Base Frame Format */
#define MSG_RTR		(1<<0)		/**< RTR Message */
#define MSG_OVR		(1<<1)		/**< CAN controller Msg overflow error */
#define MSG_EXT		(1<<2)		/**< extended message format */
#define MSG_SELF	(1<<3)		/**< message received from own tx */
#define MSG_PASSIVE	(1<<4)		/**< controller in error passive */
#define MSG_BUSOFF      (1<<5)		/**< controller Bus Off  */
#define MSG_WARNING    	(1<<6)		/**< CAN Warning Level reached */
#define MSG_BOVR	(1<<7)		/**< receive/transmit buffer overflow */

typedef struct
{
  HANDLE drv_handle;
  BOOL is_device_open;
//  BOOL is_thread_start;
//  BOOL is_thread_end;
//  agc_callback_t CallBackFunc;
//  event Event;
} DEVINFO;

struct Command_par {
  int cmd;			/**< special driver command */
  int target;			/**< special configuration target */
  unsigned long val1;		/**< 1. parameter for the target */
  unsigned long val2;		/**< 2. parameter for the target */
  int error;	 		/**< return value */
  unsigned long retval;	/**< return value */
};

/**
IOCTL Command request parameter structure */
typedef struct Command_par Command_par_t ; /**< Command parameter struct */
/**
IOCTL CConfiguration request parameter structure */
typedef struct Command_par  Config_par_t ; /**< Configuration parameter struct */

#define MAX_DEV  2
#define INPUT_NO   12
#define OUTPUT_NO  12
#define TIMER_NO   12
#define INPUT       0x00
#define COUNTER_TO  0x01
#define COUNTER_OF  0x02
#define PG_FIN      0x03
#define TIMER_FIN   0x04
#define COUNTER_REACH 0x05

#define MEMBASE    0x10
#define IOBASE     0x14
#define SRAM_MODE	0x00
# define IND		0x00
# define REP		0x01
#define PCI_ROUTING	0x01
# define INTA		0x00
# define INTB		0x01
# define INTC           0x10
# define INTD           0x11
#define INT_STS		0x02
# define INT_STS_SPI	0x01
# define INT_STS_GPO	0x02
# define INT_STS_TIMER	0x04
# define INT_STS_GPIOF	0x08
# define INT_STS_GPI	0x10
# define INT_STS_PCI	0x20
# define INT_STS_CAN	0x40  
# define INT_STS_GPITO  0x80
#define	INT_GPI		0x08
# define GPI_DATA	0x04
# define GPI_AUTOCLEAR	0x0E
# define GPI_INT_ENABLE	0x0A
# define GPI_MODE	0x06
# define GPI_TRIG_TYPE	0x12
# define GPI_INT_OF	0x0C
# define GPI_INT_TO	0x10
# define GPI_DBOUNCE	0x18
# define GPI_TO_BASE	0x14
# define GPI_COUNTER	0x24
# define GPI_TARGET	0x3C
# define GPI_TO		0x54
#define INT_GPO		0x72
# define GPO_DATA	0x6C
# define GPO_MODE	0x6E
# define GPO_PG_RUN	0x70
# define GPO_PG_STOP	0x7A
# define GPO_PG_BASE	0x74
# define GPO_INT_ENABLE	0x78
# define GPO_PG_HIGH	0x7C
# define GPO_PG_LOW	0x7D
# define GPO_PG_CYCLE	0x94
#define INT_TIMER	0xAC
# define TIMER_BASE	0xB0
# define TIMER_ENABLE	0xAE
# define TIMER_VAL	0xB4
#define SPI_IN		0xE0
#define SPI_OUT		0xE1
#define SPI_CTL		0xE2
#define SPI_STA		0xE3
#define SPI_CTL2	0xE4
#ifdef __cplusplus
}
#endif

#endif	// __CAN_LIB_H_